<?php

/**
 * @file
 * Contains uc_order_handler_sort_total.
 */

/**
 * Sort handler that handles fields generated by table.fieldname * table.qty
 * and performs a simple sort.
 *
 * This sort handler is appropriate for any numeric formula that ends up
 * in the query with an alias like "table_field".
 */
class uc_order_handler_sort_total extends views_handler_sort {

  /**
   * Overrides views_handler_sort::query().
   */
  function query() {
    $this->ensure_my_table();
    // Add the field.
    $this->query->add_orderby(NULL, NULL, $this->options['order'], $this->table . '_' . $this->field);
  }

}
