(function($){
	// Responsive Slideshow
	Drupal.behaviors.dexp_bxslider = {
		attach: function(context,settings) {
			$('.dexp-bxslider').each(function(index){
        
				var $this = $(this),responsiveID = $(this).attr('id');
				var options = jmbxAdjustOptions(settings.dexpbxsliders[responsiveID],$(this).innerWidth());
        $(this).attr({
          'data-itemwidth': options.slideWidth
        })
				var slide = $(this).bxSlider(options);
        var windowW = $(window).width();
        $(window).resize(function(){
          waitForFinalEvent(function () {
            if(windowW == $(window).width()) return;
            windowW = $(window).width();
            slide.destroySlider();
            options = jmbxAdjustOptions(settings.dexpbxsliders[responsiveID],$this.innerWidth());
            slide = $this.bxSlider(options);
          }, 500, responsiveID)
        })
			});
		}
	};
	
	/*Adjust bxslider options to fix on any screen*/
	function jmbxAdjustOptions(options, container_width){
		var _options = {};
		$.extend(_options, options);
		
		if((_options.slideWidth*_options.maxSlides + (_options.slideMargin*(_options.maxSlides-1))) < container_width){
			_options.slideWidth = (container_width-(_options.slideMargin*(_options.maxSlides-1)))/_options.maxSlides;
		}else{
			_options.maxSlides = Math.floor((container_width-(_options.slideMargin*(_options.maxSlides-1)))/_options.slideWidth);
			_options.maxSlides = _options.maxSlides == 0?1:_options.maxSlides;
			_options.slideWidth = (container_width-(_options.slideMargin*(_options.maxSlides-1)))/_options.maxSlides;
		}
		return _options;
	}
  //
	var waitForFinalEvent = (function () {
    var d = {};
    return function (a, b, c) {
      if (!c) {
        c = "Don't call this twice without a uniqueId"
      }
      if (d[c]) {
        clearTimeout(d[c]);
      }
      d[c] = setTimeout(a, b);
    }
  })();
})(jQuery);